<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('revaluasi', function(Blueprint $table) {
			$table->foreign('id_tahun')->references('id')->on('tahun')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('revaluasi', function(Blueprint $table) {
			$table->foreign('id_sektor')->references('id')->on('sektor')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('revaluasi', function(Blueprint $table) {
			$table->foreign('id_perusahaan')->references('id')->on('perusahaan')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('revaluasi', function(Blueprint $table) {
			$table->dropForeign('revaluasi_id_tahun_foreign');
		});
		Schema::table('revaluasi', function(Blueprint $table) {
			$table->dropForeign('revaluasi_id_sektor_foreign');
		});
		Schema::table('revaluasi', function(Blueprint $table) {
			$table->dropForeign('revaluasi_id_perusahaan_foreign');
		});
	}
}