<?php

namespace Communicate;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Message extends Eloquent {

	protected $table = 'messages';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $guarded = array('reference_uuid');
	protected $fillable = array('title', 'body_raw', 'is_read', 'is_important');
	protected $visible = array('title', 'body_raw', 'body_parsed', 'folder_id', 'is_read', 'is_important');
	protected $hidden = array('reference_uuid');

	public function folder()
	{
		return $this->hasOne('Folder', 'folder_id');
	}

}