<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('referral_code_id')->unsigned();
			$table->string('first_name', 190);
			$table->string('last_name', 190);
			$table->tinyInteger('type')->default('2');
			$table->tinyInteger('theme')->default('1');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('id_reg_fee')->default('2');
			$table->double('current_wallet');
			$table->double('current_tickets');
			$table->date('reg_date');
			$table->date('reg_end_date');
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}