<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Ticket extends Eloquent {

	protected $table = 'tickets';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function log()
	{
		return $this->hasMany('TicketLog', 'ticket_id');
	}

	public function comments()
	{
		return $this->hasMany('TicketComments', 'ticket_id');
	}

	public function workers()
	{
		return $this->hasMany('TicketWorkers', 'ticket_id');
	}

	public function attachments()
	{
		return $this->hasMany('TicketAttachments', 'ticket_id');
	}

}