<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEstateLandsTable extends Migration {

	public function up()
	{
		Schema::create('estate_lands', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('estate_lands');
			$table->string('construction_area');
			$table->string('construction_area_type_id');
			$table->string('total');
			$table->string('total_sold');
			$table->string('sold_number');
			$table->string('land_type_id');
			$table->string('land_area');
			$table->string('land_area_type_id');
			$table->string('land_status_id');
			$table->string('is_has_construction_condition');
			$table->string('construction_condition_type');
			$table->string('construction_condition_id');
			$table->string('development_approval_number');
			$table->string('urban_plan_id');
			$table->string('aisle_area');
			$table->string('high_voltage_line_area');
			$table->string('slope_area');
			$table->string('out_basement_area');
			$table->string('use_area_id');
			$table->string('building_coverage');
			$table->string('driveway_area');
			$table->string('share_enumerator');
			$table->string('share_denominator');
			$table->string('water_service_id');
			$table->string('sewage_id');
			$table->string('gas_id');
			$table->string('drainage_id');
			$table->string('is_all_electric');
			$table->string('equipment_remark');
			$table->string('total_month_for_rent');
			$table->string('total_year_for_rent');
			$table->string('floor_area_ratio');
			$table->string('contact_road_status_id');
			$table->string('building_standard_type_id');
			$table->string('building_standard_permission_reason');
			$table->datetime('deleted_at');
			$table->string('construction_condition_period');
			$table->string('notice_ids');
		});
	}

	public function down()
	{
		Schema::drop('estate_lands');
	}
}