<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEstatesTable extends Migration {

	public function up()
	{
		Schema::create('estates', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('type_id')->unsigned();
			$table->integer('sub_type_id')->unsigned();
			$table->integer('sale_representative_id');
			$table->integer('saler_id');
			$table->integer('company_id');
			$table->integer('address_id');
			$table->integer('house_number');
			$table->integer('station_id');
			$table->integer('location_name_id');
			$table->decimal('price');
			$table->integer('advertising_condition_id');
			$table->integer('sale_status_id');
			$table->integer('commission_id');
			$table->decimal('time_walkcommission_percent');
			$table->integer('time_walk');
			$table->integer('distance_walk');
			$table->integer('time_station_to_bus');
			$table->string('bus_stop_name');
			$table->integer('distance_by_car');
			$table->integer('time_walk_to_bus');
			$table->integer('estate_structure_id');
			$table->integer('land_privilege_id');
			$table->integer('total_floor');
			$table->string('room_arrangement');
			$table->integer('land_rental_fee');
			$table->integer('delivery_time_condition_id');
			$table->integer('delivery_time_type_id');
			$table->datetime('delivered_at');
			$table->integer('delivery_season_id');
			$table->string('primary_school_name');
			$table->integer('distance_to_primary_school');
			$table->string('secondary_school_name');
			$table->string('distance_to_secondary_school');
			$table->string('hospital_name');
			$table->string('distance_to_hospital');
			$table->string('kindergarten_name');
			$table->integer('distance_to_kindergarten');
			$table->text('mediator');
			$table->datetime('created_atconfirmed_at');
			$table->datetime('deleted_at');
			$table->tinyInteger('gyopro_public_status');
			$table->date('gyopro_public_created_at');
			$table->integer('status');
			$table->integer('registered_by');
			$table->decimal('commission_value');
			$table->decimal('organization_id');
			$table->string('recommendations');
		});
	}

	public function down()
	{
		Schema::drop('estates');
	}
}