<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('estate_type_subtypes', function(Blueprint $table) {
			$table->foreign('type_id')->references('id')->on('enstate_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('estate_type_subtypes', function(Blueprint $table) {
			$table->foreign('subtype_id')->references('id')->on('estate_type_subtypes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('estates', function(Blueprint $table) {
			$table->foreign('type_id')->references('id')->on('estate_type_subtypes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('estates', function(Blueprint $table) {
			$table->foreign('sub_type_id')->references('id')->on('estate_type_subtypes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('estate_stations', function(Blueprint $table) {
			$table->foreign('estate_id')->references('id')->on('estates')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('estate_images', function(Blueprint $table) {
			$table->foreign('estate_id')->references('id')->on('estates')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('estate_sides', function(Blueprint $table) {
			$table->foreign('estate_id')->references('id')->on('estates')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('estate_slides', function(Blueprint $table) {
			$table->foreign('estate_image_id')->references('id')->on('estate_images')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('estate_image_logs', function(Blueprint $table) {
			$table->foreign('estate_id')->references('id')->on('estates')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('estate_price_logs', function(Blueprint $table) {
			$table->foreign('estate_id')->references('id')->on('estates')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('estate_notices', function(Blueprint $table) {
			$table->foreign('estate_id')->references('id')->on('estates')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('estate_mansions', function(Blueprint $table) {
			$table->foreign('estate_id')->references('id')->on('estates')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('estate_type_subtypes', function(Blueprint $table) {
			$table->dropForeign('estate_type_subtypes_type_id_foreign');
		});
		Schema::table('estate_type_subtypes', function(Blueprint $table) {
			$table->dropForeign('estate_type_subtypes_subtype_id_foreign');
		});
		Schema::table('estates', function(Blueprint $table) {
			$table->dropForeign('estates_type_id_foreign');
		});
		Schema::table('estates', function(Blueprint $table) {
			$table->dropForeign('estates_sub_type_id_foreign');
		});
		Schema::table('estate_stations', function(Blueprint $table) {
			$table->dropForeign('estate_stations_estate_id_foreign');
		});
		Schema::table('estate_images', function(Blueprint $table) {
			$table->dropForeign('estate_images_estate_id_foreign');
		});
		Schema::table('estate_sides', function(Blueprint $table) {
			$table->dropForeign('estate_sides_estate_id_foreign');
		});
		Schema::table('estate_slides', function(Blueprint $table) {
			$table->dropForeign('estate_slides_estate_image_id_foreign');
		});
		Schema::table('estate_image_logs', function(Blueprint $table) {
			$table->dropForeign('estate_image_logs_estate_id_foreign');
		});
		Schema::table('estate_price_logs', function(Blueprint $table) {
			$table->dropForeign('estate_price_logs_estate_id_foreign');
		});
		Schema::table('estate_notices', function(Blueprint $table) {
			$table->dropForeign('estate_notices_estate_id_foreign');
		});
		Schema::table('estate_mansions', function(Blueprint $table) {
			$table->dropForeign('estate_mansions_estate_id_foreign');
		});
	}
}