<?php

namespace tpa_provider_service;

use Illuminate\Database\Eloquent\Model;

class Tpa_provider_service extends Model 
{

    protected $table = 'tpa_provider_service';
    public $timestamps = true;

    public function providers()
    {
        return $this->belongsToMany('Tpa_company', 'id');
    }

    public function service_port()
    {
        return $this->belongsTo('ServicePort', 'port_id', 'service_type_id');
    }

    public function serviceType()
    {
        return $this->belongsTo('ServiceType', 'service_type_id');
    }

    public function currency()
    {
        return $this->hasOne('Currency', 'currency_id');
    }

    public function invoicePaymentTerm()
    {
        return $this->hasOne('InvoicePaymentTerm', 'invoice_payment_term_id');
    }

}