<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCajasTable extends Migration {

	public function up()
	{
		Schema::create('cajas', function(Blueprint $table) {
			$table->mediumInteger('id_caja', true)->primary();
			$table->string('marca', 60)->nullable();
			$table->string('modelo', 60)->nullable();
			$table->smallInteger('id_tamano')->unsigned();
			$table->string('num_caja', 10)->nullable();
			$table->string('placas', 20)->nullable();
			$table->mediumInteger('id_status')->unsigned();
			$table->datetime('fecha_ult_mod');
			$table->mediumInteger('id_usuario_registro');
			$table->string('comentarios', 100)->nullable();
			$table->string('vin', 50)->nullable();
			$table->string('color', 30)->nullable();
			$table->mediumInteger('id_usuario_ult_mod');
			$table->mediumInteger('id_tipo');
			$table->string('marca_llanta1', 30);
			$table->string('marca_llanta2', 30);
			$table->string('marca_llanta3', 30);
			$table->string('marca_llanta4', 30);
			$table->string('marca_llanta5', 30);
			$table->string('marca_llanta6', 30);
			$table->string('marca_llanta7', 30);
			$table->string('marca_llanta8', 30);
			$table->mediumInteger('id_cliente');
			$table->string('foto_caja', 100);
			$table->string('foto_marca');
			$table->string('foto_placas', 100);
			$table->string('foto_vin', 100);
		});
	}

	public function down()
	{
		Schema::drop('cajas');
	}
}