<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVehiculosInternosTable extends Migration {

	public function up()
	{
		Schema::create('vehiculos_internos', function(Blueprint $table) {
			$table->mediumInteger('id_vehiculo', true);
			$table->mediumInteger('id_status');
			$table->string('num_vehiculo', 10)->nullable();
			$table->string('marca', 60);
			$table->string('modelo', 60);
			$table->string('placas', 20);
			$table->string('vin', 50);
			$table->string('color', 30);
			$table->mediumInteger('id_usuario_registro');
			$table->mediumInteger('id_usuario_ult_mod');
			$table->datetime('fecha_alta');
			$table->datetime('fecha_ult_mod');
			$table->mediumInteger('id_tipo_vehiculo');
			$table->mediumInteger('id_cliente');
			$table->string('foto_vehiculo', 100);
			$table->string('foto_placas', 100);
			$table->string('foto_marca', 100);
			$table->string('foto_vin', 100);
		});
	}

	public function down()
	{
		Schema::drop('vehiculos_internos');
	}
}