<?php

namespace upt;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Upt extends Model 
{

    protected $table = 'upt';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('upt_nama', 'upt_kotakab', 'upt_provinsi');
    protected $visible = array('upt_nama', 'upt_kotakab', 'upt_provinsi');

    public function getKotaKab()
    {
        return $this->hasOne('KotaKab', 'id');
    }

    public function getProvinsi()
    {
        return $this->hasOne('upt\Provinsi', 'id');
    }

    public function getSpt()
    {
        return $this->hasMany('spt\Spt', 'id');
    }

}