<?php

namespace spt;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Spt extends Model 
{

    protected $table = 'spt';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('spt_nomor', 'spt_perusahaan_id', 'spt_pengawas_id', 'spt_upt_id');
    protected $visible = array('spt_nomor', 'spt_perusahaan_id', 'spt_pengawas_id', 'spt_upt_id');

    public function getLhp()
    {
        return $this->hasOne('lhp\Lhp', 'spt_lhp_id');
    }

    public function getUpt()
    {
        return $this->hasOne('upt\Upt', 'spt_upt_id');
    }

}