<?php

namespace lhp;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Lhp extends Eloquent {

	protected $table = 'lhp';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('lhp_nomor', 'lhp_tanggal', 'lhp_upt', 'lhp_perusahaan', 'lhp_temuan_id', 'lhp_temuan_isi', 'lhp_pengawas', 'lhp_mengetahui', 'lhp_kepada');
	protected $visible = array('lhp_nomor', 'lhp_tanggal', 'lhp_upt', 'lhp_perusahaan', 'lhp_temuan_id', 'lhp_pengawas', 'lhp_mengetahui', 'lhp_kepada');

	public function getTemuan()
	{
		return $this->hasMany('lhp\Temuan', 'lhp_temuan');
	}

	public function getPengawas()
	{
		return $this->hasOne('upt\Pengawas', 'lhp_pengawas');
	}

	public function getPerusahaan()
	{
		return $this->hasOne('pt\Perusahaan', 'lhp_perusahaan');
	}

	public function getUpt()
	{
		return $this->hasOne('upt\Upt', 'lhp_upt');
	}

}