<?php

namespace upt;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Pengawas extends Eloquent {

	protected $table = 'pengawas';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('pengawas_upt', 'pengawas_nip', 'pengawas_jabatan');
	protected $visible = array('pengawas_upt', 'pengawas_nip', 'pengawas_jabatan');

	public function getUpt()
	{
		return $this->hasOne('upt\Upt', 'pengawas_upt');
	}

}