<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLhpTable extends Migration {

	public function up()
	{
		Schema::create('lhp', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('lhp_nomor')->unique();
			$table->date('lhp_tanggal')->index();
			$table->string('lhp_upt')->index();
			$table->string('lhp_perusahaan', 255)->index();
			$table->string('lhp_temuan_id')->index();
			$table->longText('lhp_temuan_isi');
			$table->string('lhp_pengawas')->index();
			$table->string('lhp_mengetahui')->index();
			$table->string('lhp_kepada');
		});
	}

	public function down()
	{
		Schema::drop('lhp');
	}
}