<?php

namespace lhp;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Analisis extends Eloquent {

	protected $table = 'analisis';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('analisis_isi');
	protected $visible = array('analisis_isi');

	public function getKesimpulan()
	{
		return $this->hasOne('lhp\Kesimpulan', 'kesimpulan_id');
	}

	public function getSaran()
	{
		return $this->hasOne('lhp\Saran', 'saran_id');
	}

}