<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAdminTable extends Migration {

	public function up()
	{
		Schema::create('Admin', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('email')->unique();
			$table->string('password');
			$table->string('remember_token');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('role_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('Admin');
	}
}