<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('Role_Permission', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('Roles')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('Role_Permission', function(Blueprint $table) {
			$table->foreign('permission_id')->references('id')->on('Permissions')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('Cities', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('Countries')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('Zones', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('Cities')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('Exchange_Rates', function(Blueprint $table) {
			$table->foreign('from_currency_id')->references('id')->on('Currencies')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('Exchange_Rates', function(Blueprint $table) {
			$table->foreign('to_currency_id')->references('id')->on('Currencies')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('Subscriptions', function(Blueprint $table) {
			$table->foreign('currency_id')->references('id')->on('Currencies')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('Tenants', function(Blueprint $table) {
			$table->foreign('subscription_id')->references('id')->on('Subscriptions')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('Tenants', function(Blueprint $table) {
			$table->foreign('owner_id')->references('id')->on('Users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('Sessions', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('Users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('Count_translation', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('Countries')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('Admin', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('Roles')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('Role_Permission', function(Blueprint $table) {
			$table->dropForeign('Role_Permission_role_id_foreign');
		});
		Schema::table('Role_Permission', function(Blueprint $table) {
			$table->dropForeign('Role_Permission_permission_id_foreign');
		});
		Schema::table('Cities', function(Blueprint $table) {
			$table->dropForeign('Cities_country_id_foreign');
		});
		Schema::table('Zones', function(Blueprint $table) {
			$table->dropForeign('Zones_city_id_foreign');
		});
		Schema::table('Exchange_Rates', function(Blueprint $table) {
			$table->dropForeign('Exchange_Rates_from_currency_id_foreign');
		});
		Schema::table('Exchange_Rates', function(Blueprint $table) {
			$table->dropForeign('Exchange_Rates_to_currency_id_foreign');
		});
		Schema::table('Subscriptions', function(Blueprint $table) {
			$table->dropForeign('Subscriptions_currency_id_foreign');
		});
		Schema::table('Tenants', function(Blueprint $table) {
			$table->dropForeign('Tenants_subscription_id_foreign');
		});
		Schema::table('Tenants', function(Blueprint $table) {
			$table->dropForeign('Tenants_owner_id_foreign');
		});
		Schema::table('Sessions', function(Blueprint $table) {
			$table->dropForeign('Sessions_user_id_foreign');
		});
		Schema::table('Count_translation', function(Blueprint $table) {
			$table->dropForeign('Count_translation_country_id_foreign');
		});
		Schema::table('Admin', function(Blueprint $table) {
			$table->dropForeign('Admin_role_id_foreign');
		});
	}
}