<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('orderReference', 40)->nullable();
			$table->date('orderDate');
			$table->enum('orderStatus', array('Draft', 'Completed'));
			$table->integer('user_id')->unsigned();
			$table->integer('fund_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}