<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateQuestionChoicesTable extends Migration {

	public function up()
	{
		Schema::create('question_choices', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('question_id')->unsigned();
			$table->string('value')->nullable();
			$table->string('title');
			$table->boolean('status')->default(true);
		});
	}

	public function down()
	{
		Schema::drop('question_choices');
	}
}