<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAdminsTable extends Migration {

	public function up()
	{
		Schema::create('admins', function(Blueprint $table) {
			$table->smallIncrements('id', true);
			$table->string('first_name', 50);
			$table->string('last_name', 50);
			$table->string('password', 255);
			$table->string('email', 90)->unique();
			$table->string('phone', 15);
			$table->boolean('status')->default(true);
			$table->timestampsTz('timestamps');
			$table->string('time_zone', 5)->default('UTC');
		});
	}

	public function down()
	{
		Schema::drop('admins');
	}
}