<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSellersTable extends Migration {

	public function up()
	{
		Schema::create('sellers', function(Blueprint $table) {
			$table->smallIncrements('id', true);
			$table->string('first_name', 50);
			$table->string('last_name', 50);
			$table->string('email', 90);
			$table->string('phone', 15)->unique();
			$table->string('password', 255);
			$table->tinyInteger('status')->default('0');
			$table->timestampsTz('timestamps');
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('sellers');
	}
}