<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAdConstraintsTable extends Migration {

	public function up()
	{
		Schema::create('ad_constraints', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->json('continents');
			$table->json('countries');
			$table->json('regions');
			$table->json('cities');
			$table->json('browsers');
			$table->json('os');
			$table->json('device_types');
			$table->json('domains');
			$table->json('blacklist_domains');
			$table->json('ipaddresses');
			$table->json('blacklist_ipaddresses');
			$table->json('urls');
			$table->json('blacklist_urls');
			$table->json('gps_latitude_longtitude_radius');
			$table->json('genres');
			$table->json('categories');
			$table->json('keywords');
			$table->json('contain_words');
			$table->json('maturities');
			$table->json('markets');
			$table->json('contents');
			$table->json('applications');
			$table->json('time_of_the_day');
			$table->json('day_of_the_week');
			$table->json('day_of_the_month');
		});
	}

	public function down()
	{
		Schema::drop('ad_constraints');
	}
}