<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAdGroupsTable extends Migration {

	public function up()
	{
		Schema::create('ad_groups', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->enum('status', array('ENABLED', 'DISABLED'));
			$table->integer('weight');
			$table->enum('priority', array(''));
			$table->integer('type_id')->unsigned();
			$table->integer('constraint_id');
			$table->text('notes');
			$table->integer('show_chance_percentage');
			$table->integer('owner_id');
			$table->integer('ad_constraint_id')->unsigned();
			$table->integer('expire_after_impression_click_count');
			$table->integer('expire_after_impression');
			$table->integer('expire_after_cost');
			$table->datetime('start_date');
			$table->datetime('end_date');
		});
	}

	public function down()
	{
		Schema::drop('ad_groups');
	}
}