<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePositionsTable extends Migration {

	public function up()
	{
		Schema::create('positions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->integer('type_id')->unsigned();
			$table->enum('status', array('ACTIVE', 'DEACTIVE', 'PENDING'));
			$table->integer('subsystem_id');
			$table->integer('application_id');
			$table->enum('type', array('public', 'private'));
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('positions');
	}
}