<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('ads', function(Blueprint $table) {
			$table->foreign('ad_group_id')->references('id')->on('ad_groups')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ad_groups', function(Blueprint $table) {
			$table->foreign('type_id')->references('id')->on('types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ad_groups', function(Blueprint $table) {
			$table->foreign('ad_constraint_id')->references('id')->on('ad_constraints')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('positions', function(Blueprint $table) {
			$table->foreign('type_id')->references('id')->on('types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('impressions', function(Blueprint $table) {
			$table->foreign('position_id')->references('id')->on('positions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('impressions', function(Blueprint $table) {
			$table->foreign('ad_group_id')->references('id')->on('ad_groups')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('impressions', function(Blueprint $table) {
			$table->foreign('ad_id')->references('id')->on('ads')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('position_costs', function(Blueprint $table) {
			$table->foreign('position_id')->references('id')->on('positions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('ads', function(Blueprint $table) {
			$table->dropForeign('ads_ad_group_id_foreign');
		});
		Schema::table('ad_groups', function(Blueprint $table) {
			$table->dropForeign('ad_groups_type_id_foreign');
		});
		Schema::table('ad_groups', function(Blueprint $table) {
			$table->dropForeign('ad_groups_ad_constraint_id_foreign');
		});
		Schema::table('positions', function(Blueprint $table) {
			$table->dropForeign('positions_type_id_foreign');
		});
		Schema::table('impressions', function(Blueprint $table) {
			$table->dropForeign('impressions_position_id_foreign');
		});
		Schema::table('impressions', function(Blueprint $table) {
			$table->dropForeign('impressions_ad_group_id_foreign');
		});
		Schema::table('impressions', function(Blueprint $table) {
			$table->dropForeign('impressions_ad_id_foreign');
		});
		Schema::table('position_costs', function(Blueprint $table) {
			$table->dropForeign('position_costs_position_id_foreign');
		});
	}
}