<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('product_items', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('price_special_numbers', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('price_special_number_categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('faqs', function(Blueprint $table) {
			$table->foreign('faq_category_id')->references('id')->on('faq_categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('product_items', function(Blueprint $table) {
			$table->dropForeign('product_items_product_id_foreign');
		});
		Schema::table('price_special_numbers', function(Blueprint $table) {
			$table->dropForeign('price_special_numbers_category_id_foreign');
		});
		Schema::table('faqs', function(Blueprint $table) {
			$table->dropForeign('faqs_faq_category_id_foreign');
		});
	}
}