<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFightsTable extends Migration {

	public function up()
	{
		Schema::create('fights', function(Blueprint $table) {
			$table->increments('id', true);
			$table->integer('player_id')->unsigned();
			$table->integer('enemy_id')->unsigned();
			$table->boolean('complete')->default(0);
			$table->boolean('won');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('fights');
	}
}