<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTableTable extends Migration {

	public function up()
	{
		Schema::create('users_table', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('first_name', 64);
			$table->string('last_name', 64);
			$table->string('user_name', 128);
			$table->string('contact', 64);
			$table->string('email', 64);
			$table->string('password', 64);
			$table->string('address', 128);
			$table->string('role', 32);
			$table->integer('balance');
			$table->string('status', 32);
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users_table');
	}
}