<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderDetailsTableTable extends Migration {

	public function up()
	{
		Schema::create('order_details_table', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('order_id')->unsigned();
			$table->float('price');
			$table->float('due');
			$table->integer('package_id')->unsigned();
			$table->timestamps();
			$table->softDeletes();
			$table->integer('subtotal');
		});
	}

	public function down()
	{
		Schema::drop('order_details_table');
	}
}