<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class MenuItem extends Model 
{

    protected $table = 'menu_items';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function orders()
    {
        return $this->belongsToMany('\Order')->withPivot('quantity');
    }

    public function categories()
    {
        return $this->belongsTo('Category');
    }

}