<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class MenuItem extends Eloquent {

	protected $table = 'menu_items';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function orders()
	{
		return $this->belongsToMany('\Order')->withPivot('quantity');
	}

	public function categories()
	{
		return $this->belongsTo('Category');
	}

}