<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLimContentTypesTable extends Migration {

	public function up()
	{
		Schema::create('lim_content_types', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->enum('use_type_page', array('0', '1'));
			$table->string('type_template', 128)->nullable();
			$table->enum('use_breadcrumb_prefix', array('0', '1'));
			$table->string('content_template', 128);
			$table->integer('pagination')->unsigned()->default('0');
			$table->enum('use_category', array('0', '1'));
			$table->enum('use_branch', array('0', '1'));
			$table->enum('use_content', array('0', '1'));
			$table->integer('cache_time')->unsigned()->default('0');
		});
	}

	public function down()
	{
		Schema::drop('lim_content_types');
	}
}