<?php

namespace App\Models;

class Branch extends Eloquent {

	protected $table = 'lim_branches';
	public $timestamps = true;
	protected $fillable = array('lim_content_type_id', 'rank');
	protected $visible = array('lim_content_type_id', 'rank');

	public function language()
	{
		return $this->hasOne('App\Models\BranchLanguage', 'lim_branch_id')->where('lim_language_id', \Config::get('app.language_id'));
	}

	public function type()
	{
		return $this->belongsTo('App\Models\ContentType', 'lim_content_type_id');
	}

	public function contents()
	{
		return $this->hasMany('App\Models\Content', 'lim_branch_id');
	}

	public function widgets()
	{
		return $this->morphToMany('App\Models\Widget', 'lim_widget_relation');
	}

	public function fields()
	{
		return $this->morphMany('App\Models\Fields', 'table');
	}

	public function languages()
	{
		return $this->hasMany('App\Models\BranchLanguage', 'lim_branch_id');
	}

	public function seoFields()
	{
		return $this->morphMany('App\Models\SeoField', 'table');
	}

	public function properties()
	{
		return $this->morphMany('App\Models\Property', 'table');
	}

}