<?php

namespace App\Models;

class Category extends Eloquent {

	protected $table = 'lim_categories';
	public $timestamps = true;
	protected $fillable = array('lim_content_type_id', 'lim_category_id', 'rank', 'lft', 'rgt', 'depth');
	protected $visible = array('lim_content_type_id', 'lim_category_id', 'rank', 'lft', 'rgt', 'depth');

	public function language()
	{
		return $this->hasOne('App\Models\CategoryLanguage', 'lim_category_id')->where('lim_language_id', \Config::get('app.language_id'));
	}

	public function type()
	{
		return $this->belongsTo('App\Models\ContentType', 'lim_content_type_id');
	}

	public function contents()
	{
		return $this->hasMany('App\Models\Content', 'lim_category_id');
	}

	public function widgets()
	{
		return $this->morphToMany('App\Models\Widget', 'lim_widget_relation');
	}

	public function fields()
	{
		return $this->morphMany('App\Models\Fields', 'table');
	}

	public function languages()
	{
		return $this->hasMany('App\Models\CategoryLanguage', 'lim_category_id');
	}

	public function seoFields()
	{
		return $this->morphMany('App\Models\SeoField', 'table');
	}

	public function properties()
	{
		return $this->morphMany('App\Models\Property', 'table');
	}

}