<?php

namespace App\Models;

class SeoField extends Eloquent {

	protected $table = 'lim_seo_fields';
	public $timestamps = true;
	protected $fillable = array('lim_seo_template_id', 'table_id', 'table_type', 'rank');
	protected $visible = array('lim_seo_template_id', 'table_id', 'table_type', 'rank');

	public function language()
	{
		return $this->hasOne('App\Models\SeoFieldLanguage', 'lim_seo_field_id')->where('lim_language_id', \Config::get('app.language_id'));
	}

	public function languages()
	{
		return $this->hasMany('App\Models\SeoFieldLanguage', 'lim_seo_field_id');
	}

	public function table()
	{
		return $this->morphTo();
	}

	public function template()
	{
		return $this->belongsTo('App\Models\SeoTemplate', 'lim_seo_template_id');
	}

}