<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCeremoniesTable extends Migration {

	public function up()
	{
		Schema::create('ceremonies', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('evenement_id')->unsigned()->nullable();
			$table->string('slug', 255)->nullable();
			$table->string('nom', 255)->nullable();
			$table->string('lieu', 255)->nullable();
			$table->string('coordonnees', 255)->nullable();
			$table->text('description')->nullable();
			$table->datetime('date')->nullable();
			$table->string('qr_code_menu', 255)->nullable();
			$table->string('statut', 10)->nullable()->default('0');
		});
	}

	public function down()
	{
		Schema::drop('ceremonies');
	}
}