<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePhotosTable extends Migration {

	public function up()
	{
		Schema::create('photos', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('slug', 255)->nullable();
			$table->integer('evenement_id')->unsigned()->nullable();
			$table->string('nom', 255)->nullable();
			$table->string('statut', 10)->nullable()->default('0');
		});
	}

	public function down()
	{
		Schema::drop('photos');
	}
}