<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTemoignagesTable extends Migration {

	public function up()
	{
		Schema::create('temoignages', function(Blueprint $table) {
			$table->timestamps();
			$table->softDeletes();
			$table->increments('id');
			$table->integer('evenement_id')->unsigned()->nullable();
			$table->integer('invite_id')->unsigned()->nullable();
			$table->string('slug', 255)->nullable();
			$table->string('nom', 255)->nullable();
			$table->text('texte')->nullable();
			$table->string('statut', 10)->nullable()->default('0');
		});
	}

	public function down()
	{
		Schema::drop('temoignages');
	}
}