<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Categorie extends Eloquent {

	protected $table = 'categories';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('evenement_id', 'slug', 'nom', 'statut');
	protected $visible = array('evenement_id', 'slug', 'nom', 'statut');

	public function categoriePhoto()
	{
		return $this->hasMany('App\Models\CategoriePhoto', 'categorie_id');
	}

	public function evenement()
	{
		return $this->belongsTo('App\Models\Evenement', 'evenement_id');
	}

}