<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Ceremonie extends Eloquent {

	protected $table = 'ceremonies';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('evenement_id', 'slug', 'nom', 'lieu', 'coordonnees', 'description', 'date', 'qr_code_menu', 'statut');
	protected $visible = array('evenement_id', 'slug', 'nom', 'lieu', 'coordonnees', 'description', 'date', 'qr_code_menu', 'statut');

	public function evenement()
	{
		return $this->belongsTo('App\Models\Evenement', 'evenement_id');
	}

	public function menu()
	{
		return $this->hasMany('App\Models\Menu', 'ceremonie_id');
	}

	public function invites()
	{
		return $this->belongsToMany('App\Models\Invite', 'invite_ceremonie', 'ceremonie_id', 'invite_id');
	}

	public function userCeremonies()
	{
		return $this->hasMany('App\Models\InviteCeremonie', 'ceremonie_id');
	}

	public function tables()
	{
		return $this->hasMany('App\Models\Table', 'ceremonie_id');
	}

}