<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Config extends Eloquent {

	protected $table = 'configs';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('global_admin_id', 'slug', 'texte_spontane', 'prix', 'mois_avant', 'plus_mois_avant', 'prix_plus_mois_avant', 'mois_apres', 'plus_mois_apres', 'prix_plus_mois_apres', 'infini_mois_apres', 'admin_forme', 'plus_admin_forme', 'prix_plus_admin_forme', 'infini_admin_forme', 'ceremonie_max', 'plus_ceremonie_max', 'prix_plus_ceremonie_max', 'infini_ceremonie_max', 'invite_max', 'plus_invite_max', 'prix_plus_invite_max', 'infini_invite_max', 'photo_max', 'plus_photo_max', 'prix_plus_photo_max', 'infini_photo_max', 'cagnotte_max', 'plus_cagnotte_max', 'prix_plus_cagnotte_max', 'infini_cagnotte_max', 'num_vert', 'statut');
	protected $visible = array('global_admin_id', 'slug', 'texte_spontane', 'prix', 'mois_avant', 'plus_mois_avant', 'prix_plus_mois_avant', 'mois_apres', 'plus_mois_apres', 'prix_plus_mois_apres', 'infini_mois_apres', 'admin_forme', 'plus_admin_forme', 'prix_plus_admin_forme', 'infini_admin_forme', 'ceremonie_max', 'plus_ceremonie_max', 'prix_plus_ceremonie_max', 'infini_ceremonie_max', 'invite_max', 'plus_invite_max', 'prix_plus_invite_max', 'infini_invite_max', 'photo_max', 'plus_photo_max', 'prix_plus_photo_max', 'infini_photo_max', 'cagnotte_max', 'plus_cagnotte_max', 'prix_plus_cagnotte_max', 'infini_cagnotte_max', 'num_vert', 'statut');

	public function globaleAdmin()
	{
		return $this->belongsTo('App\Models\GlobalAdmin', 'globale_admin_id');
	}

}