<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Evenement extends Eloquent {

	protected $table = 'evenements';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('defaultceremonie_id', 'slug', 'button_qr_code', 'image_qr_code', 'menu_pdf', 'nom', 'nom_madame', 'nom_monsieur', 'date', 'base_date_event', 'date_fermeture_reponse', 'email', 'histoire', 'show_cagnotte', 'pk_pay', 'sk_pay', 'apropos_madame', 'apropos_monsieur', 'invite_accompagner', 'texte_billet', 'texte_cagnotte', 'texte_envoi_invitation', 'texte_spontane', 'mois_avant', 'mois_apres', 'admin_forme', 'ceremonie_max', 'invite_max', 'photo_max', 'cagnotte_max', 'domaine', 'force_visibility', 'num_vert', 'statut');
	protected $visible = array('defaultceremonie_id', 'slug', 'button_qr_code', 'image_qr_code', 'menu_pdf', 'nom', 'nom_madame', 'nom_monsieur', 'date', 'base_date_event', 'date_fermeture_reponse', 'email', 'histoire', 'show_cagnotte', 'pk_pay', 'sk_pay', 'apropos_madame', 'apropos_monsieur', 'invite_accompagner', 'texte_billet', 'texte_cagnotte', 'texte_envoi_invitation', 'texte_spontane', 'mois_avant', 'mois_apres', 'admin_forme', 'ceremonie_max', 'invite_max', 'photo_max', 'cagnotte_max', 'domaine', 'force_visibility', 'num_vert', 'statut');

	public function questionnaire()
	{
		return $this->hasMany('App\Models\Questionnaire', 'evenement_id');
	}

	public function invite()
	{
		return $this->hasMany('App\Models\Invite', 'evenement_id');
	}

	public function adminEvenement()
	{
		return $this->hasMany('App\Models\AdminEvenement', 'evenement_id');
	}

	public function ceremonie()
	{
		return $this->hasMany('App\Models\Ceremonie', 'evenement_id');
	}

	public function defaultceremonie()
	{
		return $this->belongsTo('App\Models\Ceremonie', 'defaultceremonie_id');
	}

	public function temoignage()
	{
		return $this->hasMany('App\Models\Temoignage', 'evenement_id');
	}

	public function categorie()
	{
		return $this->hasMany('App\Models\Categorie', 'evenement_id');
	}

	public function photo()
	{
		return $this->hasMany('App\Models\Photo', 'evenement_id');
	}

	public function versements()
	{
		return $this->hasMany('App\Models\Versement', 'evenement_id');
	}

}