<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class GlobalAdmin extends Eloquent {

	protected $table = 'globals_admins';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('slug', 'role', 'matricule', 'pass', 'nom', 'statut');
	protected $visible = array('slug', 'role', 'matricule', 'pass', 'nom', 'statut');

	public function adminEvenement()
	{
		return $this->hasMany('App\Models\AdminEvenement', 'globale_admin_id');
	}

	public function configs()
	{
		return $this->hasMany('App\Models\Config', 'globale_admin_id');
	}

}