<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class InviteTable extends Eloquent {

	protected $table = 'invites_tables';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('slug', 'invite_id', 'table_id', 'statut');
	protected $visible = array('slug', 'invite_id', 'table_id', 'statut');

	public function table()
	{
		return $this->belongsTo('App\Models\Table', 'table_id');
	}

	public function invite()
	{
		return $this->belongsTo('App\Models\Invite', 'invite_id');
	}

}