<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class PositionPhoto extends Eloquent {

	protected $table = 'positions_photos';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('slug', 'photo_id', 'position_id');
	protected $visible = array('slug', 'photo_id', 'position_id');

	public function position()
	{
		return $this->belongsTo('App\Models\Position', 'position_id');
	}

	public function photo()
	{
		return $this->belongsTo('App\Models\Photo', 'photo_id');
	}

}