<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Temoignage extends Eloquent {

	protected $table = 'temoignages';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('evenement_id', 'invite_id', 'slug', 'nom', 'texte', 'statut');
	protected $visible = array('evenement_id', 'invite_id', 'slug', 'nom', 'texte', 'statut');

	public function invite()
	{
		return $this->belongsTo('App\Models\Invite', 'invite_id');
	}

	public function evenement()
	{
		return $this->belongsTo('App\Models\Evenement', 'evenement_id');
	}

}