<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserTable extends Migration {

	public function up()
	{
		Schema::create('user', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('email', 100)->unique();
			$table->string('password', 64);
			$table->string('name', 250);
			$table->tinyInteger('usertype_id')->index();
			$table->tinyInteger('country_id')->index();
			$table->string('phone', 45);
			$table->tinyInteger('edusystem_id')->index();
			$table->string('facebookid', 45);
			$table->string('school', 45);
			$table->string('subject', 45);
			$table->string('stage', 45)->index();
			$table->bigInteger('points')->unsigned()->default('0');
		});
	}

	public function down()
	{
		Schema::drop('user');
	}
}