<?php

class User extends Eloquent {

	protected $table = 'user';
	public $timestamps = true;

	public function userType()
	{
		return $this->belongsTo('UserType');
	}

	public function country()
	{
		return $this->belongsTo('Country');
	}

	public function edusystem()
	{
		return $this->belongsTo('EduSystem');
	}

	public function feed()
	{
		return $this->hasMany('UserFeed');
	}

	public function notifications()
	{
		return $this->hasMany('Notification');
	}

	public function fahemLessons()
	{
		return $this->belongsToMany('Lesson', 'fahem');
	}

}