<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSectiondataTable extends Migration {

	public function up()
	{
		Schema::create('sectiondata', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('section_id')->unique();
			$table->integer('lessons_count')->unsigned()->default('0');
			$table->integer('shar7kamel_count')->unsigned()->default('0');
			$table->integer('videos_count')->unsigned();
			$table->tinyInteger('lesson_month')->unsigned();
			$table->bigInteger('lesson_featured')->unsigned();
			$table->string('subject_textbook', 250);
			$table->tinyInteger('edusystem_id')->index();
		});
	}

	public function down()
	{
		Schema::drop('sectiondata');
	}
}